@extends('layouts.master')
@section('title',__('Featured Tv Series'))
@section('breadcum')
  <div class="breadcrumbbar">
    <h4 class="page-title">{{ __('Featured Tv Series') }}</h4>
      <div class="breadcrumb-list">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ __('Featured Tv Series') }}</li>
          </ol>
      </div>   
  </div>
@endsection
@section('maincontent')
<div class="contentbar">
  <div class="row">
    @if ($errors->any())  
  <div class="alert alert-danger" role="alert">
  @foreach($errors->all() as $error)     
  <p>{{ $error}}<button type="button" class="close" data-dismiss="alert" aria-label="Close" title="{{ __('Close') }}">
  <span aria-hidden="true" style="color:red;">&times;</span></button></p>
      @endforeach  
  </div>
  @endif
    <div class="col-lg-12">
      <div class="card m-b-50">
        <div class="card-body ml-2">
          {!! Form::open(['method' => 'POST', 'action' => 'TvSeriesController@fupdate', 'files' => true]) !!}
          <div class="row">
            
              <!-- Blog Names (Multiple Choice) -->
              <div class="col-md-12">
                
                <div class="form-group text-dark{{ $errors->has('tv_series') ? ' has-error' : '' }}">
                    {!! Form::label('tv_series', __('Choose TV Series')) !!}<sup class="text-danger">*</sup>
                    {!! Form::select('tv_series[]', $allTVSeries, $featuredTVSeries->keys(), ['class' => 'form-control select2', 'multiple' => 'multiple', 'required']) !!}
                    <small class="text-danger">{{ $errors->first('tv_series') }}</small>
                </div>
                
            </div>
            
            
            
              <!-- Submit Button -->
              <div class="col-md-12">
                  <div class="form-group">
                      <button type="submit" class="btn btn-primary-rgba" title="{{ __('Save') }}">
                          <i class="fa fa-check-circle"></i> {{ __('Save') }}
                      </button>
                  </div>
              </div>
          </div>
          {!! Form::close() !!}
          <div class="clear-both"></div>
      </div>
      
    </div>
  </div>
</div>
@endsection 